/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include "global.h"
#include "image.h"

#ifndef _DECODER_H_
#define _DECODER_H_

/* ///////////////////////////////////////////////////////////////////////// */
/* Currently, we hard-coded the frame dimension and slice number per frame   */
/* for the DSP implementation of the video decoder.  This is ugly, but it    */
/* works fine. Make sure you change the parameter MAX_SLICE_NUMBER if your   */
/* video bitstream has a different configuration.                            */
/*                                                                           */
/* Changing the video resolution is not as simple as changing FRAME_WIDTH    */
/* and FRAME_HEIGHT parameters.  It takes more effort to do so.              */
/*                                                                           */
/* Note that on the ARM implementation, the slice number per frame is        */
/* computed automatically from the bitstream, no manual setting is required. */
/* We will change this on the DSP side for future release.                   */ 
/* ///////////////////////////////////////////////////////////////////////// */
#define FRAME_WIDTH 320
#define FRAME_HEIGHT 240
#define SLICE_NUMBER_PER_FRAME 5 // number of slices per frame
#define ROW_PER_SLICE ((FRAME_HEIGHT/MB_SIZE)/SLICE_NUMBER_PER_FRAME)
#define SLICE_MACROBLOCLK_NUMBER ((FRAME_WIDTH/MB_SIZE)*ROW_PER_SLICE)

#ifdef __cplusplus
extern  "C"
{
#endif

#define EDGE_SIZE2  (EDGE_SIZE>>1)
#define REF_UP_EDGE 16
#define REF_DOWN_EDGE 16
#define REF_UP_EDGE_2 (REF_UP_EDGE>>1)
#define REF_DOWN_EDGE_2 (REF_DOWN_EDGE>>1)

#define local_ref_column_size (8)   //15 mean all row
#define local_cur_column_size (6)

    typedef struct
    {
        // ---- Input parameters -------------------------------
        uint8  *bitstream;      // bitstream data
        uint16 *image;          // decoded YCbCr 4:2:0 frame buffer
        xint    stride;         // "width" of the frame buffer

        // ---- Output parameters ------------------------------
        xint    type;           // frame type (I-frame, or P-frame)
        uint32  timestamp;      // timestamp of the frame
        xint    width;          // video frame width
        xint    height;         // video frame height

        // ---- In/Out parameters ------------------------------
        xint    length;         // size (bytes) of the bitstream

        // ---- Internal parameters ----------------------------
        void   *handle;         // a pointer to a DECODER structure
    } DEC_CTRL;

    typedef struct
    {
        // bitstream
        uint32  shape;
        uint32  time_inc_bits;
        uint32  quant_bits;
        uint32  quant_type;
        uint32  quarterpel;

        uint32  interlacing;
        //uint32  top_field_first;
        //uint32  alternate_vertical_scan;

        // image
        uint16  width;
        uint16  height;
        uint16  edged_width;
        uint16  edged_height;

        IMAGE   cur;
        IMAGE   refn;
        IMAGE   local_cur;      //2008/1/7 04:48pm
        IMAGE   local_refn;
        IMAGE   local_refn_start;

        // macroblock
        uint16  mb_width;
        uint16  mb_height;
        uint16  num_mb;
        uint16  nbits_mba;      /* number of bits required for MB address.  CJT */
        MACROBLOCK *mbs;

        // for video packet
        xint   *slice;

        // timestamp of current frame (in millisecond)
        uint32  timestamp;
        uint32  time_inc_resolution;
        uint32  decoder_clock;
    } DECODER;

    xint    m4v_init_decoder(DEC_CTRL *vdec_obj, uint8 * video_header, xint header_size);
    xint    task_initialization(DEC_CTRL *vdec_obj);
    xint    m4v_free_decoder(DEC_CTRL *vdec_obj);
    typedef void (*FuncPtr_interpolation) (uint8 *, uint8 *, const int, const int, const int);
    typedef void (*FuncPtr_DMA_3column) (DECODER *dec, int y);
    typedef void (*FuncPtr_DMA_1column) (DECODER *dec, int x, int y);

    void decoder_islice(DEC_CTRL *vdec_obj, Bitstream *bs, xint quant,
               xint intra_dc_threshold, int slice_num);
    void decoder_pslice(DEC_CTRL *vdec_obj, Bitstream *bs, xint rounding,
               xint quant, xint fcode, xint intra_dc_threshold, int slice_num);
#ifdef __cplusplus
}
#endif

#endif                          /* _DECODER_H_ */
